/* $Id: srcrandb.c,v 1.8 1998/07/22 23:49:48 ericb Exp $ */
/* Copyright (C) 1996 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

#include <stdio.h>		/* For printf */
#include "e1432.h"

#define	BLOCKSIZE	1024
#define	SPAN		20000.0

#define SRCBLOCKSIZE	1024
#define	SRCSPAN		20000.0
#define SRCDUTYCYCLE	0.80
#define SRCRAMPTIME	0.0
/* #define SRCMODE		E1432_SOURCE_MODE_RAND */
#define SRCMODE		E1432_SOURCE_MODE_BRAND
/* #define SRCMODE		E1432_SOURCE_MODE_BSINE */
#define SINEFREQ	12800.0
#define SINEPHASE	180.0


#define TRIGMODE	TRIGMODE_AUTO
#define TRIGMODE_AUTO	0	/* 0 = autoarm/trig */
#define TRIGMODE_MAN	1	/* 1 = manual arm/trig */
#define TRIGMODE_SRC	2	/* 2 = autoarm/srctrig */

#define	IN_MAX		32
#define	SRC_MAX		5

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

/* Make these global  */
static E1432ID hw;
static SHORTSIZ16 group;
static SHORTSIZ16 chan_list[IN_MAX + SRC_MAX];
static int chan_count;

static SHORTSIZ16 in_list[IN_MAX];
static SHORTSIZ16 in_group;
static int in_count;

static SHORTSIZ16 src_list[SRC_MAX];
static SHORTSIZ16 src_group;
static int src_count;

static int
read_data(void)
{
    FLOATSIZ64 buffer[BLOCKSIZE];
    LONGSIZ32 count;
    int     i;

    (void) printf("read_data\n");
    /* Read some data */
    for (i = 0; i < in_count; i++)
    {
	CHECK(e1432_read_float64_data(hw, in_list[i],
				      E1432_TIME_DATA, buffer,
				      BLOCKSIZE, NULL, &count));
	(void) printf("channel %d    data points read =  %d\n", i, count);
	if (count != BLOCKSIZE)
	{
	    (void) fprintf(stderr, "Actual count was %d\n", count);
	    return -1;
	}
    }
    return 0;
}

int
main(void)
{
    struct e1432_hwconfig hwconfig;
    SHORTSIZ16 laddr = 8;
    int     i, error, wait, nowait, trig_mode, scan, doitforever;

    wait = 1;
    nowait = 0;
    trig_mode = TRIGMODE;
    
    /* Initialize the library */
    CHECK(e1432_init_io_driver());

    /* Uncomment this to see call tracing */
    /* e1432_trace_level(1); */

    /* Use e1432_get_hwconfig to see if the module already has
       firmware.  If this errors, assume we need to install firmware,
       so use e1432_install to do it. */
    error = e1432_get_hwconfig(1, &laddr, &hwconfig);
    if (error != 0)
    {
	(void) printf("downloading /opt/e1432/lib/sema.bin\n");
        error = e1432_install(1, &laddr, 0,
                              "/opt/e1432/lib/sema.bin");
        if (error)
	{
            (void) fprintf(stderr, "e1432_install failed, error: %d\n", error);
	    return 2;
	}
	
	CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    }

    /* Turn on debugging prints, a good idea while developing.  But do
       it after the above e1432_get_hwconfig, because we know that
       might error if the firmware is not yet installed in the
       module. */
    (void) e1432_print_errors(1);

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create input channel group */
    if ( hwconfig.input_chans > 0)
    {
	in_count = hwconfig.input_chans;
	if (in_count > IN_MAX)
	    in_count = IN_MAX;
	for (i = 0; i < in_count; i++)
	    in_list[i] = E1432_INPUT_CHAN(i+1);
	in_group = e1432_create_channel_group(hw, in_count, in_list);
	
	if (in_group >= 0)
	{
	    (void) fprintf(stderr, "e1432_create_channel_group returned %d\n",
			   in_group);
	    return 2;
	}
    }
    else
    {
	in_count =0;
    }

    /* Create source group */
    if ( hwconfig.source_chans > 0)
    {
	src_count = hwconfig.source_chans;
	if (src_count > SRC_MAX)
	    src_count = SRC_MAX;
	for (i = 0; i < src_count; i++)
	    src_list[i] = E1432_SOURCE_CHAN(i+1);
	src_group = e1432_create_channel_group(hw, src_count, src_list);
	if (src_group >= 0)
	{
	    (void) fprintf(stderr, "e1432_create_channel_group returned %d\n",
			   src_group);
	    return 2;
	}
    }
    else
    {
	src_count =0;
    }

    /* Create global channel group */
    chan_count = 0;
    for (i = 0; i < in_count; i++)
    {
	chan_list[chan_count] = in_list[i];
	chan_count = chan_count+1;
    }
    for (i = 0; i < src_count; i++)
    {
	chan_list[chan_count] = src_list[i];
	chan_count = chan_count+1;
    }
    if (chan_count > 0)
    { 
	group = e1432_create_channel_group(hw, chan_count, chan_list);
	if (group >= 0)
	{
	    (void) fprintf(stderr, "e1432_create_channel_group returned %d\n",
			   group);
	    exit(1);
	}
    }

    /* Initialize all channels */
    CHECK(e1432_set_clock_freq(hw, group,51200));
    CHECK(e1432_set_span(hw, group, SPAN));
    CHECK(e1432_set_blocksize(hw, group, BLOCKSIZE));

    /* Initialize inputs */
    CHECK(e1432_set_active(hw, in_group, E1432_CHANNEL_ON));
    CHECK(e1432_set_data_mode(hw, in_group, E1432_BLOCK_MODE));

    /* Initialize source */
    if (src_count > 0)
    {
	CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
	CHECK(e1432_set_source_mode(hw, src_group, SRCMODE));
	CHECK(e1432_set_ramp_rate(hw, src_group, SRCRAMPTIME));
	CHECK(e1432_set_range(hw, src_group, 1.0));
	CHECK(e1432_set_amp_scale(hw, src_group, 1.0));
	CHECK(e1432_set_span(hw, src_group, SRCSPAN));
	CHECK(e1432_set_source_blocksize(hw, src_group, SRCBLOCKSIZE));
	CHECK(e1432_set_duty_cycle(hw, src_group, SRCDUTYCYCLE));
/*
	CHECK(e1432_set_anti_alias_digital(hw, src_group,E1432_ANTI_ALIAS_DIGITAL_OFF));
	CHECK(e1432_set_sine_freq(hw, src_group,SINEFREQ));
	CHECK(e1432_set_sine_phase(hw, src_group,SINEPHASE));
*/
    }
    else
    {
	(void) fprintf(stderr, "Error : No source channels found\n");
	/* exit(1); */
    }

    /* Auto-zero source */
    CHECK(e1432_auto_zero(hw, src_group));

    /* Setup trigger */
    switch (trig_mode)
    {
    case TRIGMODE_MAN:
	CHECK(e1432_set_auto_arm(hw, group, E1432_MANUAL_ARM));
	CHECK(e1432_set_auto_trigger(hw, group, E1432_MANUAL_TRIGGER));
	break;
    case TRIGMODE_SRC:
	CHECK(e1432_set_auto_arm(hw, group, E1432_AUTO_ARM));
	CHECK(e1432_set_auto_trigger(hw, group, E1432_MANUAL_TRIGGER));
	CHECK(e1432_set_trigger_channel(hw,src_list[0],E1432_CHANNEL_ON));
	break;
    default:
	CHECK(e1432_set_auto_arm(hw, group, E1432_AUTO_ARM));
	CHECK(e1432_set_auto_trigger(hw,group, E1432_AUTO_TRIGGER));
	break;
    }

    (void) printf("trigger mode (0=auto,1=manual,2=src)  %d\n",trig_mode);

    /* Start measurement */
    scan = 0;
    doitforever = 1;

    (void) printf("init_measure\n");
    CHECK(e1432_init_measure(hw, group));

    while (doitforever)
    {
	if (trig_mode == TRIGMODE_MAN)
	{
	    (void) printf("arm_measure \n");
	    CHECK(e1432_arm_measure(hw, group, wait));
	    (void) printf("trigger_measure \n");
	    CHECK(e1432_trigger_measure(hw, group, nowait));
	}

	/* Wait for group block ready */
	error = 0;
	while (!error)
	{
	    (void) printf("checking block_available \n");
	    error = e1432_block_available(hw, in_group);
	    if (error < 0)
	    {
		(void) fprintf(stderr,
			       "e1432_block_available() failed, error: %d\n",
			       error);
		return 2;
	    }
	    if (error > 0)
	    {
		scan = scan +1;
		(void) printf("scan: %d\n", scan);
		CHECK(read_data());
		break;
	    }
	}	
    }

    /*NOTREACHED*/
    return 0;
}

